<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductInstance extends Model 
{

    protected $table = 'products_instances';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function abstracts()
    {
        return $this->morphMany('App\Models\Product\ProductAbstraction', 'abstractable');
    }

    public function product_variation()
    {
        return $this->belongsTo('App\Models\Product\ProductVariation', 'product_variation_id');
    }

}